/*
 * Decompiled with CFR 0.152.
 */
package turing;

public class TMTransition {
    char currentState;
    char currentChar;
    char newState;
    char newChar;
    int direction;

    public TMTransition() {
    }

    public TMTransition(String text) {
        this.setFromString(text);
    }

    public TMTransition(char cs, char cc, char ns, char nc, int dir) {
        this.setValues(cs, cc, ns, nc, dir);
    }

    public void setValues(char cs, char cc, char ns, char nc, int dir) {
        this.currentState = cs;
        this.currentChar = cc;
        this.newState = ns;
        this.newChar = nc;
        this.direction = dir;
    }

    public void setFromString(String text) {
        this.currentState = text.charAt(0);
        this.currentChar = text.charAt(2);
        this.newState = text.charAt(4);
        this.newChar = text.charAt(6);
        char ch = text.charAt(8);
        this.direction = 0;
        if (ch == 'L') {
            this.direction = -1;
        }
        if (ch == 'R') {
            this.direction = 1;
        }
    }

    public String getAsString() {
        String move = "N";
        if (this.direction == -1) {
            move = "L";
        }
        if (this.direction == 1) {
            move = "R";
        }
        return String.valueOf(this.currentState) + "," + this.currentChar + "," + this.newState + "," + this.newChar + "," + move;
    }

    public char getCurrentState() {
        return this.currentState;
    }

    public char getCurrentChar() {
        return this.currentChar;
    }

    public char getNewState() {
        return this.newState;
    }

    public char getNewChar() {
        return this.newChar;
    }

    public int getDirection() {
        return this.direction;
    }
}

